import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { mutationResponse } from "../../util/processResponse.js";

const initialState = {
    message: "",
    totalPrice: 0,
};

export const deleteSingleItem = createAsyncThunk(
    "cart/deleteSingleItem",
    async (obj) => {
        const { access_token, deleteURL, method, data } = obj;
        const response = await mutationResponse(
            deleteURL,
            method,
            data,
            access_token
        );
        return response;
    }
);

const deleteSingleItemSlice = createSlice({
    name: "cart",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(deleteSingleItem.pending, (state) => {});
        builder.addCase(deleteSingleItem.fulfilled, (state, { payload }) => {});
        builder.addCase(deleteSingleItem.rejected, (state) => {});
    },
});

export default deleteSingleItemSlice.reducer;
